package gov.va.caret.controller.dashboard.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

import javax.portlet.PortletRequest;

import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;
import gov.va.caret.view.CachedReport;
import gov.va.caret.view.EnabledSearch;
import gov.va.caret.view.GenericReport;
import gov.va.caret.view.ReportParameter;
import gov.va.caret.view.ResultMap;


public class CbopcDashboardConfig extends DashboardConfig {

	/**
	 * 
	 */
	private static final long serialVersionUID = -5910038587835405338L;
	public final String VIEW = "/jsp/dashboard/cbopc.jsp";
	final static GenericReport MY_CBOPC_WORK = new GenericReport("myCbopcWork", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX, ReportParameter.userId );
	final static GenericReport MY_NOTES = new GenericReport("myNotes", true, "creationDate", true, GenericReport.NOTES_QUERY_NDX, ReportParameter.userId );
	private GenericReport[] cbopcReports;
	
	public static GenericReport[] allCbopcQues =  new GenericReport[]{ 
			new GenericReport("vendors"),
			new GenericReport("blsRates", true, "county, city", false ),
//			new GenericReport("myCbopcWork", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX, ReportParameter.userId ),
			new GenericReport("myCscWork", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX, ReportParameter.userId ),
			new GenericReport("cbopcChampva", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("insuranceChange", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("cbopcVendor", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("cbopcReview", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("tierChange", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("revocations", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("reinstatements", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("vcgInfoChange", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("occVerify", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("occSupervisor", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("recoupments", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("rejectedPayments", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("lostChecks", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("heldPayments", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("duplicatePayments", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("occVerify", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX )
			}; 
	
	
	Collection<String> searchableWork = new HashSet<String>(Arrays.asList(new String[]{
			WorkType.ADDRESS_CHANGE.name(), 
			WorkType.CBOPC_WI.name(), 
			WorkType.DISP_APPROVED.name(),
			WorkType.DISP_REINSTATED.name(),
			WorkType.DISP_REVOKED.name(),
			WorkType.DUPLICATE_PAYMENT.name(), 
			WorkType.FACILITY_CHANGE.name(), 
			WorkType.INSURANCE_CHANGE.name(),
			WorkType.NAME_CHANGE.name(), 
			WorkType.PII_CHANGE.name(), 
			WorkType.TIER_UPDATE.name(),
			WorkType.RECOUPMENT.name(),
			WorkType.HELD_PAYMENT.name(),
			WorkType.CSC_WORK.name(),
			WorkType.VETERAN_CG_INFO_CHANGE.name(),
			WorkType.LOST_CHECK.name(),
			WorkType.REJECTED_PAYMENT.name()}));
	
	public CbopcDashboardConfig() {
		super();
		this.reports = new GenericReport[0];
		this.enabledSearch = new EnabledSearch( new CachedReport("vcgs"), new CachedReport("workItems"), new CachedReport("vendors"), new CachedReport("payments") );
	}
	
	public GenericReport[] initDashboardQus ( PortletRequest request ){
		
		Set<GenericReport> reportQues = new LinkedHashSet<GenericReport>();
		for ( CaretCan cbopcQueAction : CaretCan.CBOPC_FUNCTION.getCbopcQues () ){
			if ( CAction.canDoCaret ( request, cbopcQueAction ) ){
				String[] ques = PortletProps.getArray( cbopcQueAction.name() );
				if ( ques.length > 0 ){
					for ( String que: ques ){
						GenericReport report = getCbopcQue( que );
						if ( report!= null ){
							reportQues.add( report );
						}
					}
				}
			}
		}
		this.cbopcReports = reportQues.toArray(new GenericReport[reportQues.size()]);
		reportQues.add(MY_CBOPC_WORK);
		reportQues.add(MY_NOTES);
		this.reports = reportQues.toArray(new GenericReport[reportQues.size()]);
		return this.reports;
	}

	
	private GenericReport getCbopcQue( String queName ) {
		for ( GenericReport que: allCbopcQues ){
			if ( que.getPageName().equals( queName ) ){
				return que;
			}
		}
		return null;
	}

	public final CAction.CaretCan[] getCreateActions(){
		return new CAction.CaretCan[]{
//				CAction.CaretCan.CREATE_VENDORS
		};
	}

	@Override
	public CaretCan[] getToolsActions() {
		return new CAction.CaretCan[]{
				CAction.CaretCan.STIPEND_CALCULATOR
			};
	}
	
	public final CAction.CaretCan[] getMessageActions(){
		return new CAction.CaretCan[]{
			CAction.CaretCan.INTERNAL_MESSAGE
		};
	}
	
	@Override
	public String getView() {
		return VIEW;
	}
	
	public void loadReports( PortletRequest request ) throws ApplicationWorkFlowException{
		initDashboardQus(request);
		super.loadReports( request );
		Map<String,Object> caret = ResultMap.getCaretMap(request);
		caret.put(CaretStrPool.USE_WORKTYPES, true);
		caret.put( CaretStrPool.WORKITEM_TYPES, workItemTypes() );
		caret.put( "cgRoles", new String[]{"primary-cg", "secondary-cg", "secondary-two-cg"} );
		caret.put( CaretStrPool.VHA_SYSTEM, Toolbox.getVhaOrgTree( PortalUtil.getCompanyId( request ), true ) );
		caret.put("cbopcQue", cbopcReports);
	}
	
	public Collection<String> workItemTypes() {
		return searchableWork;
	}

}
